<?php
/**
 * Created by PhpStorm.
 * User: sebastien
 * Date: 2018-12-20
 * Time: 16:10
 */

require_once dirname(__FILE__)."/../Service/WLCConfig.php";

class BaseEndpoint
{

    /**
     * Request WLC API With Credential API Key and Glue
     * @param $endpoint
     * @param $params
     * @return bool|string
     */
    public function doAuthRequest($endpoint, $params = array()) {
        $authParams = array(
            'customerKey'   => WLCConfig::Get('KEY'),
            'apiGlue'       => WLCConfig::Get('GLUE')
        );

        return $this->request($endpoint, array_merge($params, $authParams));
    }

    /**
     * Request WLC API
     * @param $endPoint
     * @param $callData
     * @return bool|string
     */
    public function request($endPoint, $callData){
        
        $callData = http_build_query($callData);

        $context_options = array (
            'http' => array (
                'method' => 'POST',
                'header'=> "Content-type: application/x-www-form-urlencoded\r\n"
                    . "Content-Length: " . strlen($callData) . "\r\n",
                'content' => $callData
            )
        );

        $context = stream_context_create($context_options);

        $endPointDomain = $this->getDomain();

        $endPoint = $endPointDomain .'/api/' . $endPoint."/";

        $fp = @fopen($endPoint, 'r', false, $context);
        $response = false;
        if ($fp){
            while (($buffer = fgets($fp, 4096)) !== false) {
                $response .= $buffer;
            }
            if (!feof($fp)) {
            }
            fclose($fp);

        }

        return $response;
    }

    private function getDomain() {
        return 'https://pixel.welovecustomers.fr';
    }

    private function getPrefixKey($key){
        $prefix = 'WELOVECUSTOMERS_';
        if (_PS_VERSION_ < '1.6') $prefix = 'WLC_';
        return $prefix . $key;
    }
    
    

}