<?php
/**
 * Created by PhpStorm.
 * User: sebastien
 * Date: 2018-12-20
 * Time: 22:49
 */

require_once dirname(__FILE__)."/WLCConfig.php";
require_once dirname(__FILE__)."/../Endpoint/BaseEndpoint.php";

if(!class_exists("CartRule")) {
    require_once _PS_CLASS_DIR_ . "/CartRule.php";
}


class Factory
{

    private $endpoint;
    const NB_CODES = 200;
    const CODE_PREFIX = "WLC";
    const CODE_LIMIT = 200;
    const CHECK_INTERVAL = 0;
    
    public function __construct() {
        $this->endpoint = new BaseEndpoint();
    }

    /*
    * Generate new codes
    */

    public function generateNewCodes($offerName, $offerValueType, $offerValue, $offerId, $offerType, $nbCodesToGenerate = false){
        if (!$nbCodesToGenerate || (int)$nbCodesToGenerate <= 0)
        {
            $nbCodesToGenerate = self::NB_CODES;
        } else if ($nbCodesToGenerate < self::NB_CODES){
            $nbCodesToGenerate = self::NB_CODES;
        }

        $newCodes = array();
        Logger::addLog('[WLC] generateNewMasterCodes: creating '.$nbCodesToGenerate.' new codes', 1);
        for($codeNumber=$nbCodesToGenerate; $codeNumber>0;$codeNumber--){
            $code = self::CODE_PREFIX . $this->generateRandomCode(7);
            $this->createCartRule($code, $offerName, $offerValueType, $offerValue, $offerType); // creating cart rule for each codes before including it in wlc database
            $newCodes[] = $code;
        }
        $callData = array(
            'offerId'       => $offerId,
            'codes'         => $newCodes,
            'codeType'      => $offerType
        );

        Logger::addLog('[WLC] generateNewMasterCodes: adding '.count($newCodes).' new codes in wlc db', 1);
        $this->endpoint->doAuthRequest('addOfferCodes', $callData);    // adding new codes for the offer id in wlc database

        return count($newCodes);
    }

    /*
     * setting cart rule for specific code
     */
    public function createCartRule($code, $offerName, $offerValueType, $offerValue, $offerType, $minimumAmount = false, $delay = false){
        $cart_rule = new CartRule();
        // $cart_rule->group_restriction = true;
        $languages = Language::getLanguages();

        foreach ($languages as $key => $language){
            $array[$language['id_lang']]= $offerName;
        }
        $cart_rule->name = $array;
        $cart_rule->description = "Referral Code";
        $cart_rule->code = $code;
        $cart_rule->id_currency = Context::getContext()->currency->id;
        $cart_rule->active = 1;
        $cart_rule->date_from = date('Y-m-d 00:00:00');
        if ($delay){
            $cart_rule->date_to = date('Y-m-d h:i:s', mktime(0, 0, 0, date("m") + (int)$delay, date("d"), date("Y")));
        } else {
            $cart_rule->date_to = date('Y-m-d h:i:s', mktime(0, 0, 0, date("m"), date("d"), date("Y")+1));
        }
        $cart_rule->reduction_tax = 1;
        $cart_rule->reduction_currency = (int)Configuration::get('PS_CURRENCY_DEFAULT');

        // fix cumulative discount
        if (_PS_VERSION_ >= '1.7'){
            if (WLCConfig::Get('ALLOW_ON_SPECIAL') && (int)(WLCConfig::Get('ALLOW_ON_SPECIAL') != 0)){
                $cart_rule->reduction_exclude_special = false;
            } else {
                $cart_rule->reduction_exclude_special = true;
            }
        }
        
        $cart_rule->priority = 100;
        $cart_rule->quantity_per_user = 1;
        if ($offerValueType == 'percent'){
            $cart_rule->reduction_percent = $offerValue;
        } else if ($offerValueType == 'amount'){
            $cart_rule->reduction_amount = $offerValue;
        } else if ($offerValueType == 'shipping'){
            $cart_rule->free_shipping = 1;
        }

        if ($offerType != 'loyalty' && $offerType != 'product'){
            $cart_rule->cart_rule_restriction = 1;
        }

        if ($minimumAmount){
            $cart_rule->minimum_amount = $minimumAmount;
            $cart_rule->minimum_amount_currency = (int)Configuration::get('PS_CURRENCY_DEFAULT');
        }

        // if generated code will be share by customers
        if ($offerType == 'contact'){
            $cart_rule->quantity = 10000;
        }
        // adding free gift if needed for slaves or contact codes
        if ($offerType == 'contact' || $offerType == 'slave'){
            if (WLCConfig::Get('FREE_GIFT_FOR_FRIEND') && (int)(WLCConfig::Get('FREE_GIFT_FOR_FRIEND') != 0)){
                $cart_rule->gift_product = (int)WLCConfig::Get('FREE_GIFT_FOR_FRIEND');

                $product = new Product($cart_rule->gift_product);
                $cart_rule->gift_product_attribute = $product->getDefaultIdProductAttribute();
            }
        }


        $cart_rule->add();

        // fixed bug for currency
        /*
        $sql = 'UPDATE '._DB_PREFIX_.'cart_rule 
                   SET 
                    `reduction_currency` = ' . (int)Configuration::get('PS_CURRENCY_DEFAULT') . ',
                    `minimum_amount_currency` = ' . (int)Configuration::get('PS_CURRENCY_DEFAULT') . '
                WHERE `id_cart_rule` = '. (int)$cart_rule->id ;

        $currencyUpdated = Db::GetInstance()->execute($sql, false);
        */


        return $cart_rule;
    }

    /*
     * random code generation
     */
    public function generateRandomCode($length){
        $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $maxLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++){
            $randomString .= $characters[rand(0, $maxLength - 1)];
        }
        return $randomString;
    }
    
}