<?php
/**
 * Created by PhpStorm.
 * User: sebastien
 * Date: 2018-12-20
 * Time: 21:35
 */

class WLCConfig
{

    public static function Get($name) {
        return Configuration::get(self::GetPrefixKey($name));
    }

    public static function GetPrefixKey($key){
        $prefix = 'WELOVECUSTOMERS_';
        if (_PS_VERSION_ < '1.6') $prefix = 'WLC_';
        return $prefix . $key;
    }

    public static function GetColorCodeFromConfig($type){
        // getting color from configuration
        $color = Configuration::get($type);
        // remove sharp if needed
        if ($color){
            $color = self::GetSharpOut($color);
        }
        // if color is undefined or invalid
        if ($color === false){
            // initializing color
            if ($type == WLCConfig::GetPrefixKey('COLOR')){
                $color = 'FFFFFF';
            } else if ( $type == WLCConfig::GetPrefixKey('BG_COLOR')){
                $color = 'E02D74';
            } else if ($type == WLCConfig::GetPrefixKey('HEADER_COLOR')){
                $color = 'FFFFFF';
            } else if ($type == WLCConfig::GetPrefixKey('HEADER_BG_COLOR')){
                $color = 'E02D74';
            } else {
                $color = 'FFFFFF';
            }
        }
        return $color;
    }

    /*
     *  delete sharp from the hexa color code
     *  @return hexcode without sharp or false if colour in not valid
     */
    public static function GetSharpOut($hexaColor){
        if (preg_match('/^#[a-f0-9]{3,6}$/i', $hexaColor)){
            $hexaColor = substr($hexaColor,1);
        } else {
            $hexaColor = false;
        }
        return $hexaColor;
    }

}