<?php
/**
 * Created by PhpStorm.
 * User: sebastien
 * Date: 2018-12-20
 * Time: 12:01
 */

require_once dirname(__FILE__)."/../../Service/Security.php";
require_once dirname(__FILE__)."/../../Model/PostOffer.php";
require_once dirname(__FILE__)."/../../Service/Factory.php";

class wlcreferraladdofferModuleFrontController  extends ModuleFrontController
{

    private $security;
    private $factory;

    public function __construct()
    {
        $this->security = new Security();
        $this->factory = new Factory();
        parent::__construct();
    }

    public function initContent()
    {
        header('Content-Type: application/json');
        $offer = new PostOffer($_POST);
        // si les paramètres passés sont les bons
        if($this->security->isAllowedCall($offer->customerKey, $offer->apiGlue)) {
            $cartRule = $this->factory->createCartRule(
                $offer->code,
                $offer->name,
                $offer->valueType,
                $offer->value,
                $offer->type,
                (int)$offer->minimumAmount, // à caster en int,
                (int)$offer->delay // à caster en int
            );


            // on confirme l'enregistrement en retournant l'id
            echo json_encode(array(
                'status' => 200,
                'cartRuleId' => $cartRule->id
            ));
        } else {
            header($_SERVER["SERVER_PROTOCOL"]." 401 unauthorized", true, 401);
            echo json_encode(array(
                'status' => 401
            ));
        }
        die;
    }
}