<style>
    #wlc-dashboard {
        width: calc(100% - 40px);
        table-layout: fixed;
        margin: 20px auto;
    }

    #wlc-dashboard td {
        cursor: pointer;
        margin: 0;
        min-height: 70px;
        text-align: center;
        background-color: #fff;
        padding: 10px;
        border-bottom: 1px solid #ddd;
        border-left: 1px solid #ddd;
    }

    #wlc-dashboard td:first-of-type {
        border-left: none;
    }

    #wlc-dashboard dt {
        color: #777;
        padding: 0;
        margin: 0;
        height: 2.6em;
        text-align: center;
        height: 37px;
        line-height: 1em;
        font: 400 1.1em/120% "Ubuntu Condensed", Helvetica, Arial, sans-serif;
    }

    #wlc-dashboard dd {
        font-size: 1.7em;
    }

    .callout {
        position: relative;
        padding: 0 1rem;
        margin: 1rem 0;
        border-left: 4px solid #c8ced3;
        border-radius: .25rem;
        float: left;
        width: 25%;
    }

    .callout-info {
        border-left-color: #63c2de;
    }

    .callout-success {
        border-left-color: #4dbd74;
    }

    .callout small {
        font-size: 80%;
        font-weight: 400;
    }

    .callout .h4 {
        margin-bottom: .5rem;
        font-family: inherit;
        font-weight: 500;
        line-height: 1.2;
        color: inherit;
        font-size: 1.3125rem;
    }

    .row {
        width: 100%;
        clear:both;
    }

    .callout-row {
        padding: 0px 20px;
    }
</style>
{if isset($validateForm) && $validateForm == true}
    <div class="alert alert-success">{l s='Save successfully completed' mod='wlcreferral'}</div>
{/if}
{if isset($validateForm) && $validateForm == false}
    <div class="alert alert-danger">{l s='Key is empty' mod='wlcreferral'}</div>
{/if}

<div class="panel">
    <h3><i class="icon icon-dashboard"></i> {l s='Reports' mod='wlcreferral'}</h3>

    <div class="row callout-row">
        <div class="callout callout-info">
            <small class="text-muted">
                {l s='Reward offer' mod='wlcreferral'}
            </small>
            <br>
            <strong class="h4">
                {$masterOfferValue}{$masterOfferValueType}
            </strong>
        </div>
        <div class="callout callout-success">
            <small class="text-muted">
                {l s='Welcome offer' mod='wlcreferral'}
            </small>
            <br>
            <strong class="h4">
                {$slaveOfferValue}
                {$slaveOfferValueType}
            </strong>
        </div>
    </div>
    <table id="wlc-dashboard" class="row">
        <tr>
            <td class="col-xs-4 col-lg-2 label-tooltip">
                <dt>
                    {l s='Invitation' mod='wlcreferral'}
                </dt>
                <dd class="data_value size_l"><span id="net_profits_score">
                            {$invitations}
                        </span>
                </dd>
            </td>

            <td class="col-xs-4 col-lg-2 label-tooltip">
                <dt>
                    {l s='Referrer' mod='wlcreferral'}
                </dt>
                <dd class="data_value size_l"><span id="net_profits_score">
                            {$rewards}
                        </span>
                </dd>
            </td>

            <td class="col-xs-4 col-lg-2 label-tooltip">
                <dt>
                    {l s='Referee' mod='wlcreferral'}
                </dt>
                <dd class="data_value size_l"><span id="net_profits_score">
                            {$welcomes}
                        </span>
                </dd>
                <dd class="dash_trend"><span id="net_profits_score_trends"></span></dd>
            </td>

            <td class="col-xs-4 col-lg-2 label-tooltip">
                <dt>
                    {l s='NPS score' mod='wlcreferral'}
                </dt>
                <dd class="data_value size_l">
                    <span id="scoreNPSValue">
                            {$scoreNPS}
                    </span>
                </dd>
                <dd class="dash_trend"><span id="net_profits_score_trends"></span></dd>
            </td>
        </tr>
    </table>

</div>

<div class="panel">
    <h3><i class="icon icon-user"></i> {l s='Account' mod='wlcreferral'}</h3>

    <p>
        {l s='After creating your account you will receive an API key' mod='wlcreferral'}.<br><br>
        {l s='Please create your WeLoveCustomers account using this link: ' mod='wlcreferral'}<a
                href="{$weLoveCustomersUrl}" target="_blank">{l s='Create my referral program' mod='wlcreferral'}</a>
    </p>

</div>

<style>
    #imgIconPreviewContainer {
        background: rgba(224, 45, 116, 0.80) url('http://s.app.welovecustomers.fr/img/textures/basketball.png');
        width: 100%;
        height: 80px;
        text-align: center;
    }

    #imgIconPreviewContainer img {
        width: 48px;
        margin: 16px auto;

    }


    /* The shortcodePopup (background) */
    .shortcodeWindow {
        opacity: 1;
        display: none; /* Hidden by default */
        position: fixed; /* Stay in place */
        z-index: 3; /* Sit on top */
        padding-top: 100px; /* Location of the box */
        left: 0;
        top: 0;
        width: 100%; /* Full width */
        height: 100%; /* Full height */
        overflow: auto; /* Enable scroll if needed */
        background-color: rgb(0, 0, 0); /* Fallback color */
        background-color: rgba(0, 0, 0, 0.4); /* Black w/ opacity */
    }

    /* shortcodePopup Content */
    .shortcodePopup-content {
        background-color: #fefefe;
        margin-left: 15%;
        margin-top: 10%;
        margin-bottom: 10%;
        padding: 20px;
        border: 1px solid #888;
        width: 80%;
    }

    .shortcodePopup-header {
        background-color: #5cb85c;
        padding: 2px 16px;
    }

    /* The Close Button */
    .close {
        color: #aaaaaa;
        float: right;
        font-size: 28px;
        font-weight: bold;
    }

    .close:hover,
    .close:focus {
        color: #000;
        text-decoration: none;
        cursor: pointer;
    }

    .icons {
        margin-left: auto;
        margin-right: auto;
    }
</style>
<script>

    function displayIcon(elt) {
        if ($('#imgIconPreviewContainer')) {
            $('#imgIconPreviewContainer').remove();
        }
        elt.parent().append('<div id="imgIconPreviewContainer"><img src="http://s.app.welovecustomers.fr/widgets/img/referral-box-corner-' + elt.val() + '.png" /></div>');
    }

    $(document).ready(function () {
        $('#WELOVECUSTOMERS_ICON').change(function () {
            displayIcon($(this));
        });

        // init
        displayIcon($('#WELOVECUSTOMERS_ICON'));


        var score = parseInt($("#scoreNPSValue").html());
        var color = '#666';
        if (score < -20) {
            color = '#DC3912';
        } else if (score >= -20 && score < 20) {
            color = '#FF9900';
        } else if (score >= 20) {
            color = '#109618';
        }
        $("#scoreNPSValue").css("color", color);

    });
    var shortcodeWindow = document.getElementById('shortcodePopup');

    // Get the button that opens the shortcodePopup
    var btn = document.getElementById("shortcodeBouton");

    // When the user clicks the button, open the shortcodePopup 
    btn.onclick = function () {
        shortcodeWindow.style.display = "block";
    }

    // When the user clicks anywhere outside of the shortcodePopup, close it
    window.onclick = function (event) {
        if (event.target == shortcodeWindow) {
            shortcodeWindow.style.display = "none";
        }
    }
</script>