<?php
/**
 * 2016-2024 WeLoveCustomers
 *
 * NOTICE OF LICENSE
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    WeLoveCustomers <hello@welovecustomers.fr>
 *  @copyright 2016-2024 WeLoveCustomers
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

require_once dirname(__FILE__)."/Service/WLCConfig.php";
require_once dirname(__FILE__)."/Endpoint/BaseEndpoint.php";
require_once dirname(__FILE__)."/Service/Factory.php";
foreach (glob(dirname(__FILE__)."/controllers/front/*.php") as $filename) {
    require_once($filename) ;
}

class Wlcreferral extends Module
{
    protected $config_form = false;
    private $endpoint;
    private $factory;

    public function __construct()
    {
        $this->endpoint = new BaseEndpoint();
        $this->factory = new Factory();

        $this->name = 'wlcreferral';
        $this->tab = 'advertising_marketing';
        $this->version = '2.7.0.0';
        $this->author = 'WeLoveCustomers';
        $this->need_instance = 1;
        $this->ps_versions_compliancy = array('min' => '1.5.3', 'max' => _PS_VERSION_);
        $this->debug = false;
        //$this->module_key='';

        /**
         * Set $this->bootstrap to true if your module is compliant with bootstrap (PrestaShop 1.6)
         */
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Referral new program by We Love Customers');
        $this->description = $this->l('Add a new referral program to your website');

        $this->confirmUninstall = $this->l('Are you sure you want to uninstall referral program module ?');

    }

    /**
     * Don't forget to create update methods if needed:
     * http://doc.prestashop.com/display/PS16/Enabling+the+Auto-Update
     */
    public function install()
    {

        // on ajoute les url de l'api
        $this->insertApiUrl();

        Configuration::updateValue(WLCConfig::GetPrefixKey('KEY'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('GLUE'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('TITLE'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('COLOR'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('HEADER_COLOR'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('BG_COLOR'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('HEADER_BG_COLOR'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('ICON'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('STATUS'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('POSITION'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('SPECIFIC_PROMPT'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('CORNER_BOX'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('ACCOUNT_BOX'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('POSTPURCHASE_BOX'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('DETAILORDER_BOX'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('MEMBERSHIP_WIDGET'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('MEMBERSHIP_WIDGET_LOYALTY'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('MEMBERSHIP_WIDGET_REFERRAL'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('MULTILINGUAL'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('LAST_CHECK_COUPONS'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('STYLE'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('FREE_GIFT_FOR_FRIEND'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('LOYALTY_WIDGET_CONFIG'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('LOYALTY_BOX'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('BIGBOARD_WIDGET'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('BIGBOARD_WIDGET_CONFIG_CODE'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('BIGBOARD_WIDGET_ACCOUNT_CONFIG_CODE'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('REFERRAL_WIDGET_ACCOUNT_CONFIG_CODE'), false);

        Configuration::updateValue(WLCConfig::GetPrefixKey('REGISTER_WIDGET'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('REGISTER_WIDGET_CONFIG_CODE'), false);

        Configuration::updateValue(WLCConfig::GetPrefixKey('ID_FIRST_CUSTOMER_TO_SEND'), false);


        Configuration::updateValue(WLCConfig::GetPrefixKey('ALLOW_ON_SPECIAL'), false);
        Configuration::updateValue(WLCConfig::GetPrefixKey('PRICE_TYPE'), false);

        $hookRegistration =
                parent::install() &&
                $this->registerHook('displayFooter') &&
                $this->registerHook('actionPaymentConfirmation') &&
                $this->registerHook('actionOrderStatusPostUpdate') &&
                $this->registerHook('displayOrderConfirmation') &&
                $this->registerHook('displayOrderDetail') &&
                $this->registerHook('displayCustomerAccount') &&
                $this->registerHook('actionOrderStatusUpdate') &&
                $this->registerHook('actionObjectCustomerAddAfter') &&
                $this->registerHook('actionObjectCustomerUpdateAfter') &&
                $this->registerHook('actionCustomerAccountAdd') &&
                $this->registerHook('actionCustomerAccountUpdate') &&
                $this->registerHook('actionCartSave');


        if (_PS_VERSION_ >= '1.7'){
            $hookRegistration == $hookRegistration && $this->registerHook('filterCmsContent');
        }



        return $hookRegistration;
    }

    /**
     * Retourne la liste des urls nécessaire à l'api
     * @return array
     */
    private function getApiUrl() {
        return array(
            'module-wlcreferral-config' => 'wlc/config/check',
            'module-wlcreferral-addoffer' => 'wlc/offer/add',
            'module-wlcreferral-removeoffer' => 'wlc/offer/remove'
        );
    }

    /**
     * Insert API Url on Database
     */
    private function insertApiUrl() {
        $db = Db::GetInstance();
        foreach($this->getApiUrl() as $page => $url) {

            $sql = 'SELECT id_meta FROM '._DB_PREFIX_.'meta WHERE page = "'.$page.'"';
            $metaId = $db->getValue($sql);

            // si la page n'existe pas on la crée
            if(!$metaId) {
                $response = $db->insert('meta', array(
                    'page' => $page
                ));

                $sql = 'SELECT id_meta FROM '._DB_PREFIX_.'meta WHERE page = "'.$page.'"';
                $metaId = $db->getValue($sql);
            }


            foreach(Language::getLanguages(true) as $language) {

                $sql = 'SELECT id_meta FROM '._DB_PREFIX_.'meta_lang WHERE url_rewrite = "'.$url.'" AND id_lang ='. $language['id_lang'];
                $metaLangId = $db->getValue($sql);

                // si l'url rewrite n'existe pas, on la crée
                if(!$metaLangId) {
                    $db->insert('meta_lang', array(
                        'id_meta' => $metaId,
                        'id_shop' => 1,
                        'id_lang' => $language['id_lang'],
                        'url_rewrite' => $url
                    ));
                }
            }
        }
    }


    public function uninstall()
    {
        Configuration::deleteByName(WLCConfig::GetPrefixKey('KEY'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('GLUE'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('TITLE'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('COLOR'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('HEADER_COLOR'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('BG_COLOR'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('HEADER_BG_COLOR'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('ICON'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('STATUS'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('POSITION'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('SPECIFIC_PROMPT'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('CORNER_BOX'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('ACCOUNT_BOX'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('POSTPURCHASE_BOX'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('DETAILORDER_BOX'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('MEMBERSHIP_WIDGET'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('MEMBERSHIP_WIDGET_LOYALTY'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('MEMBERSHIP_WIDGET_REFERRAL'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('MULTILINGUAL'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('LAST_CHECK_COUPONS'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('STYLE'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('FREE_GIFT_FOR_FRIEND'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('LOYALTY_WIDGET_CONFIG'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('LOYALTY_BOX'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('BIGBOARD_WIDGET'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('BIGBOARD_WIDGET_CONFIG_CODE'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('BIGBOARD_WIDGET_ACCOUNT_CONFIG_CODE'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('REFERRAL_WIDGET_ACCOUNT_CONFIG_CODE'));

        Configuration::deleteByName(WLCConfig::GetPrefixKey('REGISTER_WIDGET'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('REGISTER_WIDGET_CONFIG_CODE'));

        Configuration::deleteByName(WLCConfig::GetPrefixKey('ALLOW_ON_SPECIAL'));
        Configuration::deleteByName(WLCConfig::GetPrefixKey('PRICE_TYPE'));

        return parent::uninstall();
    }

    
    private function wlcDebug($message){

        $message = date('Y-m-d H:i:s'). ' ' .$message;
        $res = file_put_contents('/tmp/wlc-prestashop.txt', $message . "\r\n", FILE_APPEND);
        // var_dump($message);
    }

    /**
     * Load the configuration form
     */
    public function getContent()
    {
        // $this->wlcDebug(__METHOD__);

        /**
         * If values have been submitted in the form, process.
         */
        $validateForm = null;
        if (((bool)Tools::isSubmit('submitWeLoveCustomersModule')) == true) {
            $validateForm = $this->postProcess();
        }


        // generate new master codes if customer wants it
        $referralInfos = $this->referralInfos();
        $stats = $this->getStats();
        $lastPrestashopModuleVersion = false;
        if (WLCConfig::Get('KEY')){

            $response = $this->endpoint->doAuthRequest('prestashopPluginVersion');

            if ($response){
                $objResponse = json_decode($response);
                $lastPrestashopModuleVersion = $objResponse->version;
            }
        }

        $this->context->smarty->assign('module_dir', $this->_path);
        $this->context->smarty->assign(array('validateForm' => $validateForm));

        $this->context->smarty->assign('weLoveCustomersUrl', 'https://www.welovecustomers.fr/developpez-le-parrainage-en-e-commerce/?utm_campaign=install-plugin&utm_source=prestashop&utm_medium='.$this->version.'&utm_term='._PS_BASE_URL_);
        $this->context->smarty->assign('pluginVersion', $this->version);
        $this->context->smarty->assign('currentBackofficeUrl', $_SERVER['REQUEST_URI']);
        $this->context->smarty->assign('lastPrestashopModuleVersion', $lastPrestashopModuleVersion);

        $masterOfferValue = $masterOfferValueType = false;
        $slaveOfferValue = $slaveOfferValueType = false;
        if ($referralInfos != false){
            if ($referralInfos['masterOfferValueType'] == 'percent'){
                $masterOfferValue = $referralInfos['masterOfferValue'];
                $masterOfferValueType = '%';
            } else if ($referralInfos['masterOfferValueType'] == 'amount'){
                $masterOfferValue =  $referralInfos['masterOfferValue'];
                $masterOfferValueType =  '€';
            } else if ($referralInfos['masterOfferValueType'] == 'point'){
                $masterOfferValue =  $referralInfos['masterOfferValue'];
                $masterOfferValueType =  'pts';
            } else if ($referralInfos['masterOfferValueType'] == 'shipping'){
                $masterOfferValue = 'Free shipping';
            }
            if ($referralInfos['slaveOfferValueType'] == 'percent'){
                $slaveOfferValue = $referralInfos['slaveOfferValue'];
                $slaveOfferValueType = '%';
            } else if ($referralInfos['slaveOfferValueType'] == 'amount'){
                $slaveOfferValue = $referralInfos['slaveOfferValue'];
                $slaveOfferValueType = '€';
            } else if ($referralInfos['slaveOfferValueType'] == 'point'){
                $slaveOfferValue =  $referralInfos['slaveOfferValue'];
                $slaveOfferValueType =  'pts';
            } else if ($referralInfos['slaveOfferValueType'] == 'shipping'){
                $slaveOfferValue = 'Free shipping';
            }
        }

        $this->context->smarty->assign('masterOfferValue', $masterOfferValue);
        $this->context->smarty->assign('masterOfferValueType', $masterOfferValueType);
        $this->context->smarty->assign('slaveOfferValue', $slaveOfferValue);
        $this->context->smarty->assign('slaveOfferValueType', $slaveOfferValueType);
        if ($referralInfos){
            $this->context->smarty->assign('countMasterAvailableCodes', $this->countAvailableCodes($referralInfos['masterOfferId'], 'coupon'));
            $this->context->smarty->assign('countContactAvailableCodes', $this->countAvailableCodes($referralInfos['masterOfferId'], 'contact'));
            $this->context->smarty->assign('countSlaveAvailableCodes', $this->countAvailableCodes($referralInfos['slaveOfferId'], 'coupon'));
        }

        $this->context->smarty->assign('scoreNPS', $this->nps());

        $this->context->smarty->assign('debug', $this->debug);

        if($stats) {
            $this->context->smarty->assign('invitations', $stats->contact);
            $this->context->smarty->assign('rewards', $stats->father);
            $this->context->smarty->assign('welcomes', $stats->slave);
        } else {
            $this->context->smarty->assign('invitations', "-");
            $this->context->smarty->assign('rewards', "-");
            $this->context->smarty->assign('welcomes', "-");
        }

        $output = $this->context->smarty->fetch($this->local_path.'views/templates/admin/configure.tpl');

        return $output . $this->renderForm();

    }

    /**
     * Create the form that will be displayed in the configuration of your module.
     */
    protected function renderForm()
    {
        $helper = new HelperForm();

        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);

        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitWeLoveCustomersModule';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false)
            .'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');


        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFormValues(), /* Add values for your inputs */
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        );

        // added for PS 1.5.x
        $helper->fields_value = $this->getConfigFormValues();

        return $helper->generateForm(array($this->getConfigForm()));
    }

    /**
     * Create the structure of your form.
     */
    protected function getConfigForm()
    {

        $options = array(
                  array(
                    'id_option' => 0,
                    'name' => $this->l('Disabled')
                  ),array(
                    'id_option' => 1,
                    'name' => $this->l('Enabled')
                  ),
        );

        $statuses = array(
                  array(
                    'id_option' => 'extended',
                    'name' => $this->l('Extended')
                  ),
                  array(
                    'id_option' => 'collapsed',
                    'name' => $this->l('Collapsed')
                  ),
        );
        $positions = array(
                  array(
                    'id_option' => 'bottom-right',
                    'name' => $this->l('Bottom right')
                  ),
                  array(
                    'id_option' => 'top-right',
                    'name' => $this->l('Top right')
                  )
        );
        $priceTypes = array(
                  array(
                    'id_option' => 'with-tax-no-shipping',
                    'name' => $this->l('With tax - No shipping fees')
                  ),
                  array(
                    'id_option' => 'no-tax-no-shipping',
                    'name' => $this->l('No tax - No shipping fees')
                  ),
                  array(
                    'id_option' => 'no-tax-shipping',
                    'name' => $this->l('No tax - With shipping fees')
                  ),
                  array(
                    'id_option' => 'with-tax-shipping',
                    'name' => $this->l('With tax - With shipping fees')
                  )
        );

        $styles = array(
                  array(
                    'id_option' => 'basic',
                    'name' => $this->l('Basic')
                  ),
                  array(
                    'id_option' => 'minimal',
                    'name' => $this->l('Minimal')
                  ),
        );
        $icons = array(
                  array(
                    'id_option' => 'gift',
                    'name' => $this->l('gift')
                  ),
                  array(
                    'id_option' => 'cash',
                    'name' => $this->l('cash')
                  ),
                  array(
                    'id_option' => 'rocket',
                    'name' => $this->l('rocket')
                  ),
                  array(
                    'id_option' => 'heart',
                    'name' => $this->l('heart')
                  ),
                  array(
                    'id_option' => 'share',
                    'name' => $this->l('share')
                  ),
                  array(
                    'id_option' => 'discount',
                    'name' => $this->l('discount')
                  ),
                  array(
                    'id_option' => 'like',
                    'name' => $this->l('like')
                  ),
                  array(
                    'id_option' => 'reward',
                    'name' => $this->l('reward')
                  ),
                  array(
                    'id_option' => 'euro',
                    'name' => $this->l('euro')
                  ),
                  array(
                    'id_option' => 'euro2',
                    'name' => $this->l('euro2')
                  ),
                  array(
                    'id_option' => 'dollar',
                    'name' => $this->l('dollar')
                  ),
                  array(
                    'id_option' => 'icecream',
                    'name' => $this->l('icecream')
                  ),
                  array(
                    'id_option' => 'plant',
                    'name' => $this->l('plant')
                  ),
                  array(
                    'id_option' => 'white-gift',
                    'name' => $this->l('white-gift')
                  )
        );
        return array(
            'form' => array(
                'legend' => array(
                'title' => $this->l('Settings'),
                'icon' => 'icon-cogs',
                ),
                'input' => array(
                    array(
                        'col' => 3,
                        'type' => 'text',
                        'prefix' => '<i class="icon icon-key"></i>',
                        'desc' => $this->l('Enter your key'),
                        'name' => WLCConfig::GetPrefixKey('KEY'),
                        'label' => $this->l('WeLoveCustomers key'),
                    ),
                    array(
                        'col' => 3,
                        'type' => 'text',
                        'prefix' => '<i class="icon icon-lock"></i>',
                        'desc' => $this->l('Enter glue'),
                        'name' => WLCConfig::GetPrefixKey('GLUE'),
                        'label' => $this->l('WeLoveCustomers glue'),
                    ),
                    /*
                    array(
                        'col' => 3,
                        'type' => 'select',
                        'prefix' => '<i class="icon icon-power-off"></i>',
                        'desc' => $this->l('Enable corner box widget'),
                        'name' => WLCConfig::GetPrefixKey('CORNER_BOX'),
                        'label' => $this->l('Corner widget'),
                        'options' => array(
                            'query' => $options,
                            'id' => 'id_option',
                            'name' => 'name'
                          )
                    ),
                    array(
                        'col' => 3,
                        'type' => 'select',
                        'prefix' => '<i class="icon icon-power-off"></i>',
                        'desc' => $this->l('Select widget status'),
                        'name' => WLCConfig::GetPrefixKey('STATUS'),
                        'label' => $this->l('Corner widget status'),
                        'options' => array(
                            'query' => $statuses,
                            'id' => 'id_option',
                            'name' => 'name'
                          )
                    ),
                    array(
                        'col' => 3,
                        'type' => 'select',
                        'prefix' => '<i class="icon icon-th"></i>',
                        'desc' => $this->l('Select widget position'),
                        'name' => WLCConfig::GetPrefixKey('POSITION'),
                        'label' => $this->l('Corner widget position'),
                        'options' => array(
                            'query' => $positions,
                            'id' => 'id_option',
                            'name' => 'name'
                          )
                    ),
                    */
                    array(
                        'col' => 3,
                        'type' => 'select',
                        'prefix' => '<i class="icon icon-power-off"></i>',
                        'desc' => $this->l('Enable post purchase box widget'),
                        'name' => WLCConfig::GetPrefixKey('POSTPURCHASE_BOX'),
                        'label' => $this->l('Post purchase widget'),
                        'options' => array(
                            'query' => $options,
                            'id' => 'id_option',
                            'name' => 'name'
                          )
                    ),
                    array(
                        'col' => 3,
                        'type' => 'select',
                        'prefix' => '<i class="icon icon-power-off"></i>',
                        'desc' => $this->l('Enable detail order box widget'),
                        'name' => WLCConfig::GetPrefixKey('DETAILORDER_BOX'),
                        'label' => $this->l('Detail order widget'),
                        'options' => array(
                            'query' => $options,
                            'id' => 'id_option',
                            'name' => 'name'
                          )
                    ),
                    array(
                        'col' => 3,
                        'type' => 'select',
                        'prefix' => '<i class="icon icon-power-off"></i>',
                        'desc' => $this->l('Enable account page widget'),
                        'name' => WLCConfig::GetPrefixKey('ACCOUNT_BOX'),
                        'label' => $this->l('Account page widget'),
                        'options' => array(
                            'query' => $options,
                            'id' => 'id_option',
                            'name' => 'name'
                          )
                    ),
                    array(
                        'col' => 3,
                        'type' => 'select',
                        'prefix' => '<i class="icon icon-power-off"></i>',
                        'desc' => $this->l('Enable membership loyalty widget'),
                        'name' => WLCConfig::GetPrefixKey('MEMBERSHIP_WIDGET_LOYALTY'),
                        'label' => $this->l('Membership loyalty widget'),
                        'options' => array(
                            'query' => $options,
                            'id' => 'id_option',
                            'name' => 'name'
                          )
                    ),
                    array(
                        'col' => 3,
                        'type' => 'select',
                        'prefix' => '<i class="icon icon-power-off"></i>',
                        'desc' => $this->l('Enable membership referral widget'),
                        'name' => WLCConfig::GetPrefixKey('MEMBERSHIP_WIDGET_REFERRAL'),
                        'label' => $this->l('Membership referral widget'),
                        'options' => array(
                            'query' => $options,
                            'id' => 'id_option',
                            'name' => 'name'
                          )
                    ),
                    array(
                        'col' => 3,
                        'type' => 'text',
                        'prefix' => '<i class="icon icon-info"></i>',
                        'desc' => $this->l('Enter title'),
                        'name' => WLCConfig::GetPrefixKey('TITLE'),
                        'label' => $this->l('Widget title'),
                    ),
                    array(
                        'col' => 3,
                        'type' => 'select',
                        'prefix' => '<i class="icon icon-image"></i>',
                        'desc' => $this->l('Choose icon'),
                        'name' => WLCConfig::GetPrefixKey('ICON'),
                        'label' => $this->l('Widget icon'),
                        'options' => array(
                            'query' => $icons,
                            'id' => 'id_option',
                            'name' => 'name'
                          )
                    ),

                    array(
                        'col' => 3,
                        'type' => 'color',
                        'prefix' => '<i class="icon icon-tint"></i>',
                        'desc' => $this->l('Choose text color'),
                        'name' => WLCConfig::GetPrefixKey('COLOR'),
                        'label' => $this->l('Widget text color')
                    ),
                    array(
                        'col' => 3,
                        'type' => 'color',
                        'prefix' => '<i class="icon icon-tint"></i>',
                        'desc' => $this->l('Choose header color'),
                        'name' => WLCConfig::GetPrefixKey('HEADER_COLOR'),
                        'label' => $this->l('Widget header color')
                    ),
                    array(
                        'col' => 3,
                        'type' => 'color',
                        'prefix' => '<i class="icon icon-tint"></i>',
                        'desc' => $this->l('Choose background color'),
                        'name' => WLCConfig::GetPrefixKey('BG_COLOR'),
                        'label' => $this->l('Widget background color')
                    ),
                    array(
                        'col' => 3,
                        'type' => 'color',
                        'prefix' => '<i class="icon icon-tint"></i>',
                        'desc' => $this->l('Choose header background color'),
                        'name' => WLCConfig::GetPrefixKey('HEADER_BG_COLOR'),
                        'label' => $this->l('Widget header background color')
                    ),
                    array(
                        'col' => 3,
                        'type' => 'select',
                        'prefix' => '<i class="icon icon-filter"></i>',
                        'desc' => $this->l('Widget style'),
                        'name' => WLCConfig::GetPrefixKey('STYLE'),
                        'label' => $this->l('Widget style'),
                        'options' => array(
                            'query' => $styles,
                            'id' => 'id_option',
                            'name' => 'name'
                          )
                    ),
                    array(
                        'col' => 3,
                        'type' => 'text',
                        'prefix' => '<i class="icon icon-plus"></i>',
                        'desc' => $this->l('Enter specific prompt'),
                        'name' => WLCConfig::GetPrefixKey('SPECIFIC_PROMPT'),
                        'label' => $this->l('Widget specific prompt'),
                    ),
                    array(
                        'col' => 3,
                        'type' => 'text',
                        'prefix' => '<i class="icon icon-gift"></i>',
                        'desc' => $this->l('Enter ID of free gift product'),
                        'name' => WLCConfig::GetPrefixKey('FREE_GIFT_FOR_FRIEND'),
                        'label' => $this->l('Free gift for invited friend'),
                    ),
                    array(
                        'col' => 3,
                        'type' => 'select',
                        'prefix' => '<i class="icon icon-power-off"></i>',
                        'desc' => $this->l('Enable account page loyalty widget'),
                        'name' => WLCConfig::GetPrefixKey('LOYALTY_BOX'),
                        'label' => $this->l('Account page loyalty widget'),
                        'options' => array(
                            'query' => $options,
                            'id' => 'id_option',
                            'name' => 'name'
                          )
                    ),
                    array(
                        'col' => 3,
                        'type' => 'text',
                        'prefix' => '<i class="icon icon-cog"></i>',
                        'desc' => $this->l('Enter loyalty widget configuration code'),
                        'name' => WLCConfig::GetPrefixKey('LOYALTY_WIDGET_CONFIG'),
                        'label' => $this->l('Loyalty widget configuration'),
                    ),
                    array(
                        'col' => 3,
                        'type' => 'select',
                        'prefix' => '<i class="icon icon-public"></i>',
                        'desc' => $this->l('Enable multilingual referral'),
                        'name' => WLCConfig::GetPrefixKey('MULTILINGUAL'),
                        'label' => $this->l('Multilingual ecommerce referral'),
                        'options' => array(
                            'query' => $options,
                            'id' => 'id_option',
                            'name' => 'name'
                          )
                    ),
                    array(
                        'col' => 3,
                        'type' => 'select',
                        'prefix' => '<i class="icon icon-public"></i>',
                        'desc' => $this->l('Enable bigboard widget'),
                        'name' => WLCConfig::GetPrefixKey('BIGBOARD_WIDGET'),
                        'label' => $this->l('Bigboard widget'),
                        'options' => array(
                            'query' => $options,
                            'id' => 'id_option',
                            'name' => 'name'
                          )
                    ),
                    array(
                        'col' => 3,
                        'type' => 'text',
                        'prefix' => '<i class="icon icon-cog"></i>',
                        'desc' => $this->l('Enter configuration code'),
                        'name' => WLCConfig::GetPrefixKey('BIGBOARD_WIDGET_CONFIG_CODE'),
                        'label' => $this->l('Bigboard widget configuration code')
                    ),
                    array(
                        'col' => 3,
                        'type' => 'text',
                        'prefix' => '<i class="icon icon-cog"></i>',
                        'desc' => $this->l('Enter configuration code'),
                        'name' => WLCConfig::GetPrefixKey('BIGBOARD_WIDGET_ACCOUNT_CONFIG_CODE'),
                        'label' => $this->l('Bigboard widget configuration code my account page')
                    ),
                    array(
                        'col' => 3,
                        'type' => 'text',
                        'prefix' => '<i class="icon icon-cog"></i>',
                        'desc' => $this->l('Enter configuration code'),
                        'name' => WLCConfig::GetPrefixKey('REFERRAL_WIDGET_ACCOUNT_CONFIG_CODE'),
                        'label' => $this->l('Referral widget configuration code my account page')
                    ),
                    array(
                        'col' => 3,
                        'type' => 'select',
                        'prefix' => '<i class="icon icon-public"></i>',
                        'desc' => $this->l('Enable register widget'),
                        'name' => WLCConfig::GetPrefixKey('REGISTER_WIDGET'),
                        'label' => $this->l('Register widget'),
                        'options' => array(
                            'query' => $options,
                            'id' => 'id_option',
                            'name' => 'name'
                          )
                    ),
                    array(
                        'col' => 3,
                        'type' => 'text',
                        'prefix' => '<i class="icon icon-cog"></i>',
                        'desc' => $this->l('Enter configuration code'),
                        'name' => WLCConfig::GetPrefixKey('REGISTER_WIDGET_CONFIG_CODE'),
                        'label' => $this->l('Register widget configuration code')
                    ),
                    array(
                        'col' => 3,
                        'type' => 'select',
                        'prefix' => '<i class="icon icon-tag"></i>',
                        'desc' => $this->l('Allow discount on special prices'),
                        'name' => WLCConfig::GetPrefixKey('ALLOW_ON_SPECIAL'),
                        'label' => $this->l('Allow discount on special prices'),
                        'options' => array(
                            'query' => $options,
                            'id' => 'id_option',
                            'name' => 'name'
                          )
                    ),
                    array(
                        'col' => 3,
                        'type' => 'select',
                        'prefix' => '<i class="icon icon-th"></i>',
                        'desc' => $this->l('Select price types'),
                        'name' => WLCConfig::GetPrefixKey('PRICE_TYPE'),
                        'label' => $this->l('Price types'),
                        'options' => array(
                            'query' => $priceTypes,
                            'id' => 'id_option',
                            'name' => 'name'
                          )
                    ),
                ),
                'submit' => array(
                    'title' => $this->l('Save')
                ),
            ),
        );
    }


    /**
     * Set values for the inputs.
     */
    protected function getConfigFormValues()
    {
        return array(
            WLCConfig::GetPrefixKey('KEY') => WLCConfig::Get('KEY'),
            WLCConfig::GetPrefixKey('GLUE') => WLCConfig::Get('GLUE'),
            WLCConfig::GetPrefixKey('TITLE') => WLCConfig::Get('TITLE'),
            WLCConfig::GetPrefixKey('COLOR') => WLCConfig::Get('COLOR'),
            WLCConfig::GetPrefixKey('BG_COLOR') => WLCConfig::Get('BG_COLOR'),
            WLCConfig::GetPrefixKey('HEADER_COLOR') => WLCConfig::Get('HEADER_COLOR'),
            WLCConfig::GetPrefixKey('HEADER_BG_COLOR') => WLCConfig::Get('HEADER_BG_COLOR'),
            WLCConfig::GetPrefixKey('ICON') => WLCConfig::Get('ICON'),
            WLCConfig::GetPrefixKey('STATUS') => WLCConfig::Get('STATUS'),
            WLCConfig::GetPrefixKey('POSITION') => WLCConfig::Get('POSITION'),
            WLCConfig::GetPrefixKey('SPECIFIC_PROMPT') => WLCConfig::Get('SPECIFIC_PROMPT'),
            WLCConfig::GetPrefixKey('CORNER_BOX') => WLCConfig::Get('CORNER_BOX'),
            WLCConfig::GetPrefixKey('ACCOUNT_BOX') => WLCConfig::Get('ACCOUNT_BOX'),
            WLCConfig::GetPrefixKey('POSTPURCHASE_BOX') => WLCConfig::Get('POSTPURCHASE_BOX'),
            WLCConfig::GetPrefixKey('DETAILORDER_BOX') => WLCConfig::Get('DETAILORDER_BOX'),
            WLCConfig::GetPrefixKey('MEMBERSHIP_WIDGET') => WLCConfig::Get('MEMBERSHIP_WIDGET_LOYALTY'),
            WLCConfig::GetPrefixKey('MEMBERSHIP_WIDGET_LOYALTY') => WLCConfig::Get('MEMBERSHIP_WIDGET_LOYALTY'),
            WLCConfig::GetPrefixKey('MEMBERSHIP_WIDGET_REFERRAL') => WLCConfig::Get('MEMBERSHIP_WIDGET_REFERRAL'),
            WLCConfig::GetPrefixKey('MULTILINGUAL') => WLCConfig::Get('MULTILINGUAL'),
            WLCConfig::GetPrefixKey('LAST_CHECK_COUPONS') => WLCConfig::Get('LAST_CHECK_COUPONS'),
            WLCConfig::GetPrefixKey('STYLE') => WLCConfig::Get('STYLE'),
            WLCConfig::GetPrefixKey('FREE_GIFT_FOR_FRIEND') => WLCConfig::Get('FREE_GIFT_FOR_FRIEND'),
            WLCConfig::GetPrefixKey('LOYALTY_WIDGET_CONFIG') => WLCConfig::Get('LOYALTY_WIDGET_CONFIG'),
            WLCConfig::GetPrefixKey('LOYALTY_BOX') => WLCConfig::Get('LOYALTY_BOX'),
            WLCConfig::GetPrefixKey('BIGBOARD_WIDGET') => WLCConfig::Get('BIGBOARD_WIDGET'),
            WLCConfig::GetPrefixKey('BIGBOARD_WIDGET_CONFIG_CODE') => WLCConfig::Get('BIGBOARD_WIDGET_CONFIG_CODE'),
            WLCConfig::GetPrefixKey('BIGBOARD_WIDGET_ACCOUNT_CONFIG_CODE') => WLCConfig::Get('BIGBOARD_WIDGET_ACCOUNT_CONFIG_CODE'),
            WLCConfig::GetPrefixKey('REFERRAL_WIDGET_ACCOUNT_CONFIG_CODE') => WLCConfig::Get('REFERRAL_WIDGET_ACCOUNT_CONFIG_CODE'),

            WLCConfig::GetPrefixKey('REGISTER_WIDGET') => WLCConfig::Get('REGISTER_WIDGET'),
            WLCConfig::GetPrefixKey('REGISTER_WIDGET_CONFIG_CODE') => WLCConfig::Get('REGISTER_WIDGET_CONFIG_CODE'),
            WLCConfig::GetPrefixKey('ALLOW_ON_SPECIAL') => WLCConfig::Get('ALLOW_ON_SPECIAL'),
            WLCConfig::GetPrefixKey('PRICE_TYPE') => WLCConfig::Get('PRICE_TYPE')
        );
    }

    /**
     * Save form data.
     */
    protected function postProcess()
    {
        $res = true;
        $form_values = $this->getConfigFormValues();
        foreach (array_keys($form_values) as $key) {
            $res = $res && Configuration::updateValue($key, Tools::getValue($key));
        }
        return $res;
    }

    /**
     *  shortcodes hook
     */
    public function hookFilterCmsContent($params){
        $params['object']['content'] = $this->updateContent($params['object']['content']);
        return [
            'object' => $params['object']
        ];
    }

    public function updateContent($content){
        $content = urldecode($content);

        if (strpos($content, '{{wlc_box')){
            //getting overload of shortcode wlc_box
            $overload = $this->between('{{wlc_box', '}}', $content);
            $overload = str_replace('#', '', $overload);
            $overloadParam = $this->getOverloadParam($overload);
            //sending overload to display
            $boxWidget = $this->displayWLCBox($overloadParam);
            //return display of shortcode
            $content = preg_replace('#{{wlc_box'.$overload.'}}#',$boxWidget,$content);
        }

        if (strpos($content, '{{wlc_dashboard')){
            //getting overload of shortcode wlc_dashboard
            $overload = $this->between('{{wlc_dashboard', '}}', $content);
            $overload = str_replace('#', '', $overload);
            $overloadParam = $this->getOverloadParam($overload);
            $dashboardWidget = $this->displayCustomerDashboard($overloadParam['bgColor'], $overloadParam['headerColor'], $overloadParam['headerBgColor'], $overloadParam['image'], $overloadParam['title']);
            $content = preg_replace('#{{wlc_dashboard'.$overload.'}}#',$dashboardWidget,$content);
        }


        if (strpos($content, '{{wlc_loyalty')){
            $overload = $this->between('{{wlc_loyalty', '}}', $content);
            $overload = str_replace('#', '', $overload);
            $overloadParam = $this->getOverloadParam($overload);
            $loyaltyWidget = $this->displayWLCLoyaltyBox($overloadParam);

            //return display of shortcode
            $content = preg_replace('#{{wlc_loyalty'.$overload.'}}#',$loyaltyWidget,$content);
        }


        if (strpos($content, '{{wlc_bigboard')){
            $overload = $this->between('{{wlc_bigboard', '}}', $content);
            $overload = str_replace('#', '', $overload);
            $overloadParam = $this->getOverloadParam($overload);
            $bigboardWidget = $this->displayWLCBigboard($overloadParam);

            //return display of shortcode
            $content = preg_replace('#{{wlc_bigboard'.$overload.'}}#',$bigboardWidget,$content);
        }

        return $content;
    }

    //getting all overload parameters and returning it to updateContent
    public function getOverloadParam($overload){
        $param = array(
                'color'       => false,
                'bgColor'       => false,
                'headerColor'   => false,
                'headerBgColor' => false,
                'image'         => false,
                'title'         => false,
                'widgetConfig'  => false
        );
        if (stripos($overload, 'color')){
            $param['color'] = $this->between(' color:"', '"', $overload);
            if ($param['color'] == false){
                $param['color'] = $this->between(' color="', '"', $overload);
            }
        }
        if (stripos($overload, 'color-background')){
            $param['bgColor'] = $this->between(' color-background:"', '"', $overload);
            if ($param['bgColor'] == false){
                $param['bgColor'] = $this->between(' color-background="', '"', $overload);
            }
        }
        if (stripos($overload, 'header-color')){
            $param['headerColor'] = $this->between(' header-color:"', '"', $overload);
            if ($param['headerColor'] == false){
                $param['headerColor'] = $this->between(' header-color="', '"', $overload);
            }
        }
        if (stripos($overload, 'header-background-color')){
            $param['headerBgColor'] = $this->between(' header-background-color:"', '"', $overload);
            if ($param['headerBgColor'] == false){
                $param['headerBgColor'] = $this->between(' header-background-color="', '"', $overload);
            }
        }
        if (stripos($overload, 'image')){
            $image = $this->between(' image:"', '"', $overload);
            if ($image == false){
                $image = $this->between(' image="', '"', $overload);
            }
            if ($image == 'cash' || $image == 'share' || $image == 'gift' || $image == 'heart' || $image == 'like' || $image == 'rocket' || $image == 'reward' || $image == 'discount' || $image == 'dollar' || $image == 'euro' || $image == 'euro2' || $image == 'icecream' || $image == 'plant' || $image == 'white-gift'){
                $param['image'] = $image;
            }
        }
        if (stripos($overload, 'title')){
            $param['title'] = $this->between(' title:"', '"', $overload);
            if ($param['title'] == false){
                $param['title'] = $this->between(' title="', '"', $overload);
            }
        }
        if (stripos($overload, 'widget-config')){
            $param['widget-config'] = $this->between(' widget-config:"', '"', $overload);
            if ($param['widget-config'] == false){
                $param['widget-config'] = $this->between(' widget-config="', '"', $overload);
            }
        }

        return $param;
    }

    public function between($string1, $string2, $content)
    {
        return $this->before($string2, $this->after($string1, $content));
    }

    public function before($string1, $content)
    {
        return substr($content, 0, strpos($content, $string1));
    }

    public function after($string1, $content)
    {
        if (!is_bool(strpos($content, $string1)))
        return substr($content, strpos($content,$string1)+strlen($string1));
    }

    //assign parameters to wlc-box.tpl
    public function displayWLCBox($params){
        $html = false;
        $this->context->smarty->assign('weLoveCustomersKey', WLCConfig::Get('KEY'));
        if ($params['title']){
            $this->context->smarty->assign('weLoveCustomersTitle', $params['title']);
        }else{
            $this->context->smarty->assign('weLoveCustomersTitle', WLCConfig::Get('TITLE'));
        }
        if ($params['color']){
            $this->context->smarty->assign('weLoveCustomersColor', $params['color']);
        }else{
            $this->context->smarty->assign('weLoveCustomersColor', WLCConfig::GetColorCodeFromConfig(WLCConfig::GetPrefixKey('COLOR')));
        }
        if ($params['bgColor']){
            $this->context->smarty->assign('weLoveCustomersBgColor', $params['bgColor']);
        }else{
            $this->context->smarty->assign('weLoveCustomersBgColor', WLCConfig::GetColorCodeFromConfig(WLCConfig::GetPrefixKey('BG_COLOR')));
        }
        if ($params['headerColor']){
            $this->context->smarty->assign('weLoveCustomersHeaderColor', $params['headerColor']);
        }else{
            $this->context->smarty->assign('weLoveCustomersHeaderColor', WLCConfig::GetColorCodeFromConfig(WLCConfig::GetPrefixKey('HEADER_COLOR')));
        }
        if ($params['headerBgColor']){
            $this->context->smarty->assign('weLoveCustomersHeaderBgColor', $params['headerBgColor']);
        } else {
            $this->context->smarty->assign('weLoveCustomersHeaderBgColor', WLCConfig::GetColorCodeFromConfig(WLCConfig::GetPrefixKey('HEADER_BG_COLOR')));
        }
        if ($params['image']){
            $this->context->smarty->assign('weLoveCustomersIcon', $params['image']);
        } else {
            $this->context->smarty->assign('weLoveCustomersIcon', WLCConfig::Get('ICON'));
        }



        $this->context->smarty->assign('customerName', $this->context->customer->lastname);
        $this->context->smarty->assign('customerFirstname', $this->context->customer->firstname);

        $this->context->smarty->assign('customerEmail', $this->context->customer->email);
        $this->context->smarty->assign('weLoveCustomersLabel', '');
        $this->context->smarty->assign('weLoveCustomersUrl', '');
        $this->context->smarty->assign('weLoveCustomersStyle', WLCConfig::Get('STYLE'));
        $html = $this->context->smarty->fetch($this->local_path.'views/templates/front/referralbox.tpl');

        return $html;
    }

    //assign parameters to dashboard.tpl
    public function displayCustomerDashboard($bgColor, $headerColor, $headerBgColor, $image, $title){
        $html = false;
        $this->context->smarty->assign('customerName', $this->context->customer->lastname);
        $this->context->smarty->assign('customerFirstname', $this->context->customer->firstname);

        $this->context->smarty->assign('customerEmail', $this->context->customer->email);
        $this->context->smarty->assign('weLoveCustomersKey', WLCConfig::Get('KEY'));

        if ($bgColor){
            $this->context->smarty->assign('weLoveCustomersBgColor', $bgColor);
        }else{
            $this->context->smarty->assign('weLoveCustomersBgColor', WLCConfig::GetColorCodeFromConfig(WLCConfig::GetPrefixKey('BG_COLOR')));
        }
        if ($headerColor){
            $this->context->smarty->assign('weLoveCustomersHeaderColor', $headerColor);
        }else{
            $this->context->smarty->assign('weLoveCustomersHeaderColor', WLCConfig::GetColorCodeFromConfig(WLCConfig::GetPrefixKey('HEADER_COLOR')));
        }
        if ($headerBgColor){
            $this->context->smarty->assign('weLoveCustomersHeaderBgColor', $headerBgColor);
        }else{
            $this->context->smarty->assign('weLoveCustomersHeaderBgColor', WLCConfig::GetColorCodeFromConfig(WLCConfig::GetPrefixKey('HEADER_BG_COLOR')));
        }
        if ($image){
            $this->context->smarty->assign('weLoveCustomersIcon', $image);
        }else{
            $this->context->smarty->assign('weLoveCustomersIcon', WLCConfig::Get('ICON'));
        }
        if ($title){
            $this->context->smarty->assign('weLoveCustomersTitle', $title);
        }else{
            $this->context->smarty->assign('weLoveCustomersTitle', WLCConfig::Get('TITLE'));
        }

        $this->context->smarty->assign('weLoveCustomersStyle', WLCConfig::Get('STYLE'));

        $this->context->smarty->assign('customerName', $this->context->customer->lastname);
        $this->context->smarty->assign('customerFirstname', $this->context->customer->firstname);

        $this->context->smarty->assign('customerEmail', $this->context->customer->email);

        $html = $this->context->smarty->fetch($this->local_path.'views/templates/front/dashboard.tpl');

        return $html;
    }


    //assign parameters to wlc-box.tpl
    public function displayWLCLoyaltyBox($params = false){
        $html = '';
        $this->context->smarty->assign('weLoveCustomersKey', WLCConfig::Get('KEY'));

        $this->context->smarty->assign('widgetConfig', WLCConfig::Get('LOYALTY_WIDGET_CONFIG'));

        $this->context->smarty->assign('customerName', $this->context->customer->lastname);
        $this->context->smarty->assign('customerFirstname', $this->context->customer->firstname);

        $this->context->smarty->assign('customerEmail', $this->context->customer->email);
        $html = $this->context->smarty->fetch($this->local_path.'views/templates/front/loyaltybox.tpl');

        return $html;
    }



    public function displayWLCBigboard($params = false){
        $html = '';

        $this->context->smarty->assign('weLoveCustomersKey', WLCConfig::Get('KEY'));
        if ($params && is_array($params) && isset($params['widget-config'])){
           $this->context->smarty->assign('widgetConfig', $params['widget-config']);
        } else {
           $this->context->smarty->assign('widgetConfig', WLCConfig::Get('BIGBOARD_WIDGET_CONFIG_CODE'));
        }

        
        $this->context->smarty->assign('customerName', $this->context->customer->lastname);
        $this->context->smarty->assign('customerFirstname', $this->context->customer->firstname);

        $this->context->smarty->assign('customerEmail', $this->context->customer->email);

        $glue = WLCConfig::Get('GLUE');
        $ehash = md5($this->context->customer->email . $glue);
        $this->context->smarty->assign('weLoveCustomersDataEHash', $ehash);

        $html .= $this->context->smarty->fetch($this->local_path.'views/templates/front/bigboardbox.tpl');
        return $html;
    }


    public function hookDisplayFooter()
    {

        $html = '';
        if ((bool)WLCConfig::Get('CORNER_BOX')){

            $this->context->smarty->assign('customerName', $this->context->customer->lastname);
            $this->context->smarty->assign('customerFirstname', $this->context->customer->firstname);

            $this->context->smarty->assign('customerEmail', $this->context->customer->email);


            $this->context->smarty->assign('weLoveCustomersKey', WLCConfig::Get('KEY'));
            $this->context->smarty->assign('weLoveCustomersTitle', WLCConfig::Get('TITLE'));
            $sharpOutColor = WLCConfig::GetColorCodeFromConfig(WLCConfig::GetPrefixKey('COLOR'));
            $this->context->smarty->assign('weLoveCustomersColor', $sharpOutColor);
            $sharpOutBG = WLCConfig::GetColorCodeFromConfig(WLCConfig::GetPrefixKey('BG_COLOR'));
            $this->context->smarty->assign('weLoveCustomersBgColor', $sharpOutBG);
            $sharpOutHeader = WLCConfig::GetColorCodeFromConfig(WLCConfig::GetPrefixKey('HEADER_COLOR'));
            $this->context->smarty->assign('weLoveCustomersHeaderColor', $sharpOutHeader);
            $sharpOutHeaderBG = WLCConfig::GetSharpOut(WLCConfig::Get('HEADER_BG_COLOR'));
            $this->context->smarty->assign('weLoveCustomersHeaderBgColor', $sharpOutHeaderBG);

            $this->context->smarty->assign('weLoveCustomersIcon', WLCConfig::Get('ICON'));
            $this->context->smarty->assign('weLoveCustomersStatus', WLCConfig::Get('STATUS'));
            $this->context->smarty->assign('weLoveCustomersPosition', WLCConfig::Get('POSITION'));
            $this->context->smarty->assign('weLoveCustomersForce', WLCConfig::Get('MULTILINGUAL'));
            $html .= $this->context->smarty->fetch($this->local_path.'views/templates/front/referralcornerbox.tpl');
        }

        if ((bool)WLCConfig::Get('BIGBOARD_WIDGET')){

            $html .= $this->displayWLCBigboard();
        }
        if ((bool)WLCConfig::Get('REGISTER_WIDGET')){
            $this->context->smarty->assign('weLoveCustomersKey', WLCConfig::Get('KEY'));
            $this->context->smarty->assign('weLoveCustomersRegisterBoxConfigCode', WLCConfig::Get('REGISTER_WIDGET_CONFIG_CODE'));
            $html .= $this->context->smarty->fetch($this->local_path.'views/templates/front/registerbox.tpl');

        }
        return $html;
    }
    
   
    public function hookActionObjectCustomerAddAfter($params){
        // $this->wlcDebug(__METHOD__ . var_export($params, true));
    }


    public function hookActionObjectCustomerUpdateAfter($params){
        // $this->wlcDebug(__METHOD__ . var_export($params, true));

        /*
        // stockage birthdate
        $customer = $params['object'];

        $callData = array (
                        'data-name' => $customer->name,
                        'data-email' => $customer->email ,
                        'data-mobile' => '',
                        'data-amount' => $amount,
                        'data-lang' => $langCode,
                        'data-firstname' => $customer->firstname,
                        'data-birthday' => $customer->birthday,
                        'data-externalId' => $customer->id
                    );
        $this->endpoint->doAuthRequest('addCustomers', $callData);     
        */   

    }

    public function hookActionCustomerAccountAdd($params){
        // $this->wlcDebug(__METHOD__ . var_export($params, true));
    }



    public function hookActionCustomerAccountUpdate($params){
        // $this->wlcDebug(__METHOD__ . var_export($params, true));
    }





    public function hookDisplayOrderDetail($params){
        $html = false;
        if ((bool)WLCConfig::Get('DETAILORDER_BOX')){
            $html = $this->displaySharePurchaseWidget($params['order']);
        }
        return $html;
    }


    public function enhanceCustomerAccountLoyalty()
    {
        $this->smarty->assign([
            'url' => $this->context->link->getModuleLink('wlcreferral', 'Loyalty'),
            'id' => 'loyalty',
            'icon' => 'loyalty',
            'page' => $this->l('Loyalty menu'),
        ]);

        return $this->fetch($this->local_path.'views/templates/front/accountblock.tpl');
    }

    public function enhanceCustomerAccountReferral()
    {
        $this->smarty->assign([
            'url' => $this->context->link->getModuleLink('wlcreferral', 'Referral'),
            'id' => 'referral',
            'icon' => 'people',
            'page' => $this->l('Referral menu'),
        ]);

        return $this->fetch($this->local_path.'views/templates/front/accountblock.tpl');
    }

    public function enhanceCustomerAccountMissions()
    {
        $this->smarty->assign([
            'url' => $this->context->link->getModuleLink('wlcreferral', 'Missions'),
            'id' => 'missions',
            'icon' => 'games',
            'page' => 'Missions',
        ]);

        return $this->fetch($this->local_path.'views/templates/front/accountblock.tpl');
    }

    public function enhanceCustomerAccountGift()
    {
        $this->smarty->assign([
            'url' => $this->context->link->getModuleLink('wlcreferral', 'Gift'),
            'id' => 'gift',
            'icon' => 'redeem',
            'page' => 'Cadeaux',
        ]);

        return $this->fetch($this->local_path.'views/templates/front/accountblock.tpl');
    }



    /**
     * This hook displays new elements on the customer account page
     *
     * @param array $params
     *
     * @return string
     */
    public function hookDisplayCustomerAccount($params){
        $html = '';
        if ((bool)WLCConfig::Get('MEMBERSHIP_WIDGET_LOYALTY')){
            $html .= $this->enhanceCustomerAccountLoyalty();
        }
        if ((bool)WLCConfig::Get('MEMBERSHIP_WIDGET_REFERRAL')){
            $html .= $this->enhanceCustomerAccountReferral();
        }

        
        /*
        $html .= $this->enhanceCustomerAccountMissions();
        $html .= $this->enhanceCustomerAccountGift();
        */
        /*
        if ((bool)WLCConfig::Get('MEMBERSHIP_WIDGET')
            ||(bool)WLCConfig::Get('ACCOUNT_BOX')
            ||(bool)WLCConfig::Get('LOYALTY_BOX')){
            $this->context->smarty->assign('customerName', $this->context->customer->lastname);
            $this->context->smarty->assign('customerFirstname', $this->context->customer->firstname);

            $this->context->smarty->assign('customerEmail', $this->context->customer->email);

            $this->context->smarty->assign('weLoveCustomersKey', WLCConfig::Get('KEY'));
            $this->context->smarty->assign('weLoveCustomersColor', WLCConfig::GetColorCodeFromConfig(WLCConfig::GetPrefixKey('COLOR')));
            $this->context->smarty->assign('weLoveCustomersBgColor', WLCConfig::GetColorCodeFromConfig(WLCConfig::GetPrefixKey('BG_COLOR')));
            $this->context->smarty->assign('weLoveCustomersHeaderColor', WLCConfig::GetColorCodeFromConfig(WLCConfig::GetPrefixKey('HEADER_COLOR')));
            $this->context->smarty->assign('weLoveCustomersHeaderBgColor', WLCConfig::GetColorCodeFromConfig(WLCConfig::GetPrefixKey('HEADER_BG_COLOR')));
            $this->context->smarty->assign('weLoveCustomersMembership', WLCConfig::Get('MEMBERSHIP_WIDGET'));
            $this->context->smarty->assign('weLoveCustomersAccountBox', WLCConfig::Get('ACCOUNT_BOX'));
            $this->context->smarty->assign('weLoveCustomersIcon', WLCConfig::Get('ICON'));

            $this->context->smarty->assign('weLoveCustomersLabel', '');
            $this->context->smarty->assign('weLoveCustomersUrl', '');

            $this->context->smarty->assign('weLoveCustomersTitle', WLCConfig::Get('TITLE'));

            $this->context->smarty->assign('weLoveCustomersLoyaltyBox', WLCConfig::Get('LOYALTY_BOX'));
            $this->context->smarty->assign('widgetConfig', WLCConfig::Get('LOYALTY_WIDGET_CONFIG'));

            $html .= $this->context->smarty->fetch($this->local_path.'views/templates/front/membership.tpl');
        }
        */
        return $html;
    }

    private function displaySharePurchaseWidget($order = false, $forceDisplay = false){
        $html = false;
        if ((bool)WLCConfig::Get('POSTPURCHASE_BOX') || $forceDisplay){
            // getting order products
            $order = ($order)?new Order((int)$order->id):false;
            $products = ($order)?$order->getProducts():false;
            // get the first product to customize widget
            if ($products) {
                $firstProduct = array_shift($products);
                $product = new Product((int)($firstProduct['id_product']));

                $link = new Link();
                $url = $link->getProductLink($product->id);
                $productName = array_shift($product->name);

                if ($prompt = WLCConfig::Get('SPECIFIC_PROMPT')){
                    $prompt = sprintf($prompt, $productName);
                }
                $this->context->smarty->assign('weLoveCustomersLabel', $prompt);
                $this->context->smarty->assign('weLoveCustomersUrl', $url);
            } else {
                $this->context->smarty->assign('weLoveCustomersLabel', '');
                $this->context->smarty->assign('weLoveCustomersUrl', '');
            }




            $this->context->smarty->assign('customerName', $this->context->customer->lastname);
            $this->context->smarty->assign('customerFirstname', $this->context->customer->firstname);

            $this->context->smarty->assign('customerEmail', $this->context->customer->email);

            $this->context->smarty->assign('weLoveCustomersKey', WLCConfig::Get('KEY'));
            $this->context->smarty->assign('weLoveCustomersTitle', WLCConfig::Get('TITLE'));
            $this->context->smarty->assign('weLoveCustomersColor', WLCConfig::GetColorCodeFromConfig(WLCConfig::GetPrefixKey('COLOR')));
            $this->context->smarty->assign('weLoveCustomersBgColor', WLCConfig::GetColorCodeFromConfig(WLCConfig::GetPrefixKey('BG_COLOR')));
            $this->context->smarty->assign('weLoveCustomersHeaderColor', WLCConfig::GetColorCodeFromConfig(WLCConfig::GetPrefixKey('HEADER_COLOR')));
            $this->context->smarty->assign('weLoveCustomersHeaderBgColor', WLCConfig::GetColorCodeFromConfig(WLCConfig::GetPrefixKey('HEADER_BG_COLOR')));
            $this->context->smarty->assign('weLoveCustomersIcon', WLCConfig::Get('ICON'));
            $this->context->smarty->assign('weLoveCustomersStyle', WLCConfig::Get('STYLE'));
            $html .= $this->context->smarty->fetch($this->local_path.'views/templates/front/referralbox.tpl');
        }
        return $html;
    }


    /*
        Version 1.7 $params['order']
        Version 1.6 $params['objOrder']
    */
    public function hookDisplayOrderConfirmation($params){
        $html = false;
        $order = isset($params['objOrder'])?$params['objOrder']:(isset($params['order'])?$params['order']:false);
        if ($order){
            $html = $this->displayPurchaseWidget($order);
            if ((bool)WLCConfig::Get('POSTPURCHASE_BOX')){
                $html .= $this->displaySharePurchaseWidget($order);
            }
        }
        return $html;
    }


    private function getAmountFromOrder($order){

        // getting coupon information
        $amount = $order->total_paid_tax_excl;
        $priceType = WLCConfig::Get('PRICE_TYPE');
        switch ($priceType){
            case 'with-tax-no-shipping':
                $amount = $order->total_paid - $order->total_shipping;

            break;
            case 'no-tax-no-shipping':
                $amount = $order->total_paid_tax_excl - $order->total_shipping;

            break;
            case 'no-tax-shipping':
                $amount = $order->total_paid_tax_excl;
            break;
            case 'with-tax-shipping':
                $amount = $order->total_paid;
            break;
            default:
                $amount = $order->total_paid_tax_excl;
        }
        return $amount;
    }

    private function getCouponsFromOrder($order){

        // getting coupon information
        $coupons = array();
        $cartRules = $order->getCartRules();
        foreach ($cartRules as $orderCartRule){
            $cartRule = new CartRule($orderCartRule['id_cart_rule']);
            $coupons[] = $cartRule->code;
        }
        return implode(',', $coupons);
    }

    private function displayPurchaseWidget($order){

        $html = false;


        // getting customer information
        $customerId = $order->id_customer;
        $customer = new Customer((int)($order->id_customer));
        $customerName =  $customer->lastname;


        $amount = $this->getAmountFromOrder($order);

        $coupons = $this->getCouponsFromOrder($order);

        $orderId = ($order->id)?$order->id:$order->id_order;

        $controlKey = md5(
                            WLCConfig::Get('GLUE') .
                            $customerName .
                            $customer->email .
                            '' .
                            $amount .
                            $coupons .
                            strtotime($order->date_add) .
                            $orderId
                        );

        $this->context->smarty->assign('weLoveCustomersKey', WLCConfig::Get('KEY'));
        $this->context->smarty->assign('weLoveCustomersDataName', $customerName);
        $this->context->smarty->assign('weLoveCustomersDataFirstname', $customer->firstname);
        $this->context->smarty->assign('weLoveCustomersDataEmail', $customer->email);
        $this->context->smarty->assign('weLoveCustomersDataMobile', '');
        $this->context->smarty->assign('weLoveCustomersDataAmount', $amount);
        $this->context->smarty->assign('weLoveCustomersDataCoupons', $coupons);
        $this->context->smarty->assign('weLoveCustomersDataTimestamp', strtotime($order->date_add));
        $this->context->smarty->assign('weLoveCustomersDataPurchaseId', $orderId);
        $this->context->smarty->assign('weLoveCustomersDataControlKey', $controlKey);
        $html = $this->context->smarty->fetch($this->local_path.'views/templates/front/purchase.tpl');

        return $html;
    }


    private function sendOrderRequest($orderId){

        /*
        array(
            'id_order' => (int) Order ID
        );
        */
        // call addbuyer
        $order = new Order($orderId);
        if ($order){
            // get customer information
            $customerId = $order->id_customer;
            $customer = new Customer((int)($order->id_customer));
            $customerName =  $customer->lastname;

            $amount = $this->getAmountFromOrder($order);
            $coupons = $this->getCouponsFromOrder($order);

            $orderId = ($order->id)?$order->id:$order->id_order;


            $dataItems = array(); 
            $products = $order->getProducts();
            

            if ($products) {
                foreach ($products as $product){
                    for ($i = 1; $i <= $product['product_quantity']; $i++) $dataItems[] = $product['reference'];
                }
            }



            $controlKey = md5(
                                WLCConfig::Get('GLUE') .
                                $customerName .
                                $customer->email .
                                '' .
                                $amount .
                                $coupons .
                                strtotime($order->date_add) .
                                $orderId .
                                implode(',',$dataItems)
                            );

            $langId = $customer->id_lang;
            $lang = new LanguageCore((int)$langId);
            $langCode = ($lang && $lang->iso_code)?$lang->iso_code:false;



            $callData = array (
                            'data-name' => $customerName,
                            'data-email' => $customer->email ,
                            'data-mobile' => '',
                            'data-amount' => $amount,
                            'data-coupons' => $coupons,
                            'data-timestamp' => strtotime($order->date_add),
                            'data-purchase-id' => $orderId,
                            'data-hash' => $controlKey,
                            'data-lang' => $langCode,
                            'data-firstname' => $customer->firstname,
                            'data-birthdate' => $customer->birthday,
                            'data-items' => implode(',',$dataItems),
                            'data-shop' => $order->id_shop
                        );
           
            $this->endpoint->doAuthRequest('addBuyer', $callData);
        }

    }

    public function checkBeforeSendOrderRequest($params){

        // $this->wlcDebug(__METHOD__ . var_export($params, true));
        $orderId = (int)$params['id_order'];


        $newOrderStatus = $params['newOrderStatus'];
        $oldOrderStatus = (isset($params['oldOrderStatus'])) ? $params['oldOrderStatus'] : false;

        if ($oldOrderStatus && is_object($oldOrderStatus) && $newOrderStatus->id == $oldOrderStatus->id) {
            // If the status hasn't changed, do nothing
            return;
        }

        
        if ($newOrderStatus->paid) {

            $this->sendOrderRequest($orderId);
        }
    }

    public function hookActionOrderStatusUpdate($params){
        $this->checkBeforeSendOrderRequest($params);

    }


    public function hookActionOrderStatusPostUpdate($params){
        $this->checkBeforeSendOrderRequest($params);
        
    }

    public function hookActionPaymentConfirmation($params){
        $orderId = (int)$params['id_order'];
        $this->sendOrderRequest($orderId);
    }

   

    public function hookActionCartSave($params){

        //return false;
        if (!$this->active || !Validate::isLoadedObject($this->context->cart)) return false;


        $customer_email = $this->context->customer->email; 
        $customer_key = WLCConfig::Get('KEY'); 
        $glue = WLCConfig::Get('GLUE'); 
        // $code = $coupon_code; 


        //return id
        $orderId = null;
        if (_PS_VERSION_ >= '9') $orderId = Order::getIdByCartId((int)($this->context->cart->id));
        else $orderId = Order::getOrderByCartId((int)($this->context->cart->id));
        

        $order = new Order($orderId);
        
        if ($order){
            $coupons = $this->getCouponsFromOrder($order);

            if ($coupons){

                $wlcCode = false;
                $couponsTab = explode(',',$coupons);
                foreach ($couponsTab as $coupon){
                    if (strpos($coupon->code, 'WLC') === 0){
                        $wlcCode = $coupon->code;
                        break;
                    }
                }
                
                // aucun code WLC
                if (!$wlcCode) return false;

                $code = $wlcCode;
                
                $url = 'https://pixel.welovecustomers.fr/api/checkOfferCode/'; 
                $postValues = array('customerKey' => $customer_key, 'glue' => $glue, 'inputCode' => $code); 

                $ch = curl_init(); 
                curl_setopt($ch, CURLOPT_URL, $url); 
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
                curl_setopt($ch, CURLOPT_HEADER, 0); 
                curl_setopt($ch, CURLOPT_POST, 1); 
                curl_setopt($ch, CURLOPT_POSTFIELDS, $postValues); 

                $result = curl_exec($ch); 
                $result = json_decode($result, true); 

                // if($result['pContact']['email'] == $customer_email && $result['offerType'] != 'P') {
                if($result['pContact']['email'] == $customer_email && !in_array($result['offerType'],array('P','G','L'))) {
                   $cartRule = new CartRule(CartRule::getIdByCode($code));
                   if (($id_cart_rule = (int)$cartRule->id) && Validate::isUnsignedId($id_cart_rule)) { 
                      $this->errors[] = Tools::displayError('You are trying to add code that created by you, It will not add to your cart.'); 
                      $delete_coupon = $this->context->cart->removeCartRule($id_cart_rule); // Removes The Coupon code 
                   }
                }
                
            }
        }

    }







    /*
     * getting all infos from referralInfos
     */
    public function referralInfos(){
        $offerInfos = false;
        $referralOfferInfos = false;

        $response = $this->endpoint->doAuthRequest('referralInfos');

        if ($response){
            
            $offerInfos = json_decode($response);
            if (is_object($offerInfos)){
                $referralOfferInfos = array();
                if ($offerInfos->masterOffer){
                    $referralOfferInfos['nameOffer1'] = $offerInfos->nameOffer1;
                    $referralOfferInfos['masterOfferId'] = $offerInfos->masterOfferId;
                    $referralOfferInfos['masterOfferValueType'] = $offerInfos->masterOffer->offerValueType;
                    $referralOfferInfos['masterOfferValue'] = $offerInfos->masterOffer->offerValue;
                }
                if ($offerInfos->slaveOffer){
                    $referralOfferInfos['nameOffer2'] = $offerInfos->nameOffer2;
                    $referralOfferInfos['slaveOfferId'] = $offerInfos->slaveOfferId;
                    $referralOfferInfos['slaveOfferValueType'] = $offerInfos->slaveOffer->offerValueType;
                    $referralOfferInfos['slaveOfferValue'] = $offerInfos->slaveOffer->offerValue;
                }
            }
        }
        return $referralOfferInfos;
    }

    public function getStats() {
        $json = $this->endpoint->doAuthRequest('getStats');
        if($json) {
            $decode = json_decode($json);
            return $decode->stats;
        }
        return null;
    }

    /*
     * Count codes remaining for offerId
     */

    public function countAvailableCodes($offerId, $codeType = false){
        $countAvailableCodesForOffer = false;
        $callData = array(
                            'offerId'       => $offerId,
                            'codeType'      => $codeType
                    );
        $response = $this->endpoint->doAuthRequest('countAvailableCodesForOffer', $callData); // getting count of codes for this offer in wlc database

        if ($response){
                $countAvailableCodesForOffer = json_decode($response);
                $countAvailableCodesForOffer = $countAvailableCodesForOffer->nbCodes;
        } else {
            $countAvailableCodesForOffer = '';
        }
        return $countAvailableCodesForOffer;
    }

    
    /*
     * Getting customer's NPS score
     */
    public function nps(){
        $scoreNPS = false;
        $response = $this->endpoint->doAuthRequest('getNPS'); // getting NPS score for this customer
        if ($response){
            $scoreNPS = json_decode($response);
            if (isset($scoreNPS->score)){
                $scoreNPS = $scoreNPS->score;
            } else $scoreNPS = '';
        } else{
            $scoreNPS = '';
        }
        return $scoreNPS;
    }
}
